@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $register = getContent('register.content', true);
    @endphp

    <section class="pt-80 pb-80">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="account-area">
                        <form class="account-from w-100" action="{{ route('user.register') }}" method="post" onsubmit="return submitUserForm();">
                            @csrf
                            <div class="form-group">
                                <label>@lang('Username')</label>
                                <input class="form-control checkUser" name="username" type="text" value="{{ old('username') }}" placeholder="@lang('Username')" required>
                                <small class="text-danger usernameExist"></small>
                            </div>
                            <div class="form-group">
                                <label>@lang('Email')</label>
                                <input class="form-control checkUser" name="email" type="email" value="{{ old('email') }}" placeholder="@lang('Email')" required>
                            </div>

                            <div class="form-group">
                                <label>@lang('Country')*</label>
                                <div class="input-group">
                                    <select class="form-control form-select" id="country" name="country">
                                        @foreach ($countries as $key => $country)
                                            <option class="text-white" data-mobile_code="{{ $country->dial_code }}" data-code="{{ $key }}" value="{{ $country->country }}">{{ __($country->country) }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>@lang('Mobile')*</label>
                                <div class="input-group">
                                    <span class="input-group-text mobile-code"></span>
                                    <input name="mobile_code" type="hidden">
                                    <input name="country_code" type="hidden">
                                    <input class="form-control checkUser" id="mobile" name="mobile" type="number" value="{{ old('mobile') }}">
                                </div>
                                <small class="text-danger mobileExist"></small>
                            </div>

                            <div class="form-group">
                                <label>@lang('Password')*</label>
                                <input class="form-control" id="password" name="password" type="password" required>
                                @if ($general->secure_password)
                                    <div class="input-popup">
                                        <p class="error lower">@lang('1 small letter minimum')</p>
                                        <p class="error capital">@lang('1 capital letter minimum')</p>
                                        <p class="error number">@lang('1 number minimum')</p>
                                        <p class="error special">@lang('1 special character minimum')</p>
                                        <p class="error minimum">@lang('6 character password')</p>
                                    </div>
                                @endif
                            </div>

                            <div class="form-group">
                                <label>@lang('Re-Password')</label>
                                <input class="form-control" name="password_confirmation" type="password" placeholder="@lang('Re-Password')">
                            </div>
                            <x-captcha />
                            @if ($general->agree)
                                <div class="col-lg-12 form-group">
                                    <div class="checkbox-wrapper d-flex align-items-center flex-wrap">
                                        <div class="custom--checkbox">
                                            <input class="checkbox--input" id="agree" name="agree" type="checkbox">
                                            <label class="checkbox--label" for="agree">
                                                @lang('I agree with')
                                                @forelse($policyPages as $item)
                                                    <a class="base--color" href="{{ route('policies', [$item->id, slug($item->data_values->title)]) }}" target="_blank">{{ __($item->data_values->title) }}</a>
                                                    {{ $loop->last ? '' : ',' }}
                                                @empty
                                                @endforelse
                                            </label>
                                        </div>

                                    </div>
                                </div>
                            @endif

                            <div class="text-center">
                                <button class="cmn-btn w-100" type="submit">@lang('Register')</button>
                            </div>
                            <p class="mt-3">@lang('Already have an account?') <a class="base--color" href="{{ route('user.login') }}">@lang('Login now')</a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade" id="existModalCenter" role="dialog" aria-labelledby="existModalCenterTitle" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="existModalLongTitle">@lang('You are with us')</h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <h6 class="text-center">@lang('You already have an account please Login ')</h6>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-dark btn-sm" data-bs-dismiss="modal" type="button">@lang('Close')</button>
                    <a class="cmn-btn btn-sm" href="{{ route('user.login') }}">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('style')
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
@endpush
@if ($general->secure_password)
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
@push('script')
    <script>
        "use strict";
        (function($) {
            @if ($mobileCode)
                $(`option[data-code={{ $mobileCode }}]`).attr('selected', '');
            @endif
            $('select[name=country]').change(function() {
                $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
                $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
                $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            });
            $('input[name=mobile_code]').val($('select[name=country] :selected').data('mobile_code'));
            $('input[name=country_code]').val($('select[name=country] :selected').data('code'));
            $('.mobile-code').text('+' + $('select[name=country] :selected').data('mobile_code'));
            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';
                if ($(this).attr('name') == 'mobile') {
                    var mobile = `${$('.mobile-code').text().substr(1)}${value}`;
                    var data = {
                        mobile: mobile,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'email') {
                    var data = {
                        email: value,
                        _token: token
                    }
                }
                if ($(this).attr('name') == 'username') {
                    var data = {
                        username: value,
                        _token: token
                    }
                }
                $.post(url, data, function(response) {
                    if (response.data != false && response.type == 'email') {
                        $('#existModalCenter').modal('show');
                    } else if (response.data != false) {
                        $(`.${response.type}Exist`).text(`${response.type} already exist`);
                    } else {
                        $(`.${response.type}Exist`).text('');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
